<?php
header('Content-Type: application/json');
require_once __DIR__ . '/wp-load.php';

// Permitir CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");

$input = json_decode(file_get_contents("php://input"), true);
$email = sanitize_email($input['email'] ?? '');
$password = $input['password'] ?? '';
$name = sanitize_text_field($input['name'] ?? '');

if (empty($email) || empty($password) || empty($name)) {
    http_response_code(400);
    echo json_encode(["error" => "Name, email and password required"]);
    exit;
}

if (email_exists($email)) {
    http_response_code(409);
    echo json_encode(["error" => "Email already registered"]);
    exit;
}

$user_id = wp_create_user($email, $password, $email);

if (is_wp_error($user_id)) {
    http_response_code(500);
    echo json_encode(["error" => "Could not create user"]);
    exit;
}

// Actualizar nombre visible
wp_update_user([
    'ID' => $user_id,
    'display_name' => $name
]);

// Éxito: devolver id de usuario
echo json_encode([
    "userId" => $user_id
]);